#!/bin/bash

# Get the directory of the script
DIR="$(cd "$(dirname "$0")" && pwd)"

# Create virtual environment
python3 -m venv "$DIR/CRAMPenv"

# Activate virtual environment
source "$DIR/CRAMPenv/bin/activate"

# Install Django
pip install django

# Navigate to the project directory
cd "$DIR/projectquestgame"

# Open the local development server in default browser
open http://127.0.0.1:8000

# Start Django development server
python manage.py runserver 