from django import forms
from .models import ExplorationData

class ExplorationDataFilterForm(forms.Form):
    RDLC_CHOICES = [
        ('Plan', 'Plan'),
        ('Collect', 'Collect'),
        ('Analyze', 'Analyze'),
        ('Share', 'Share'),
        ('QA', 'QA'),
        ('Re-Use', 'Re-Use')
    ]

    HARMFUL_EFFECTS_CHOICES = [
        ('Loss of Potential', 'Loss of Potential'),
        ('Environmental Damage', 'Environmental Damage'),
        ('Loss of Trust', 'Loss of Trust'),
        ('Misrepresentation', 'Misrepresentation'),
        ('Social Damage', 'Social Damage'),
        ('Scientific Damage', 'Scientific Damage'),
        ('Damage Risks', 'Damage Risks'),
        ('Cultural Damage', 'Cultural Damage'),
        ('Physical Damage', 'Physical Damage'),
        ('Psychological Damage', 'Psychological Damage'),
        ('Legal Damage', 'Legal Damage'),
        ('Material Damage', 'Material Damage'),
    ]

    POSSIBLE_CAUSES_CHOICES = [
        ('Insufficient Attention', 'Insufficient Attention'),
        ('Insufficient Communication', 'Insufficient Communication'),
        ('Insufficient Risk-Assessment', 'Insufficient Risk-Assessment'),
        ('No primary scientific motivation', 'No primary scientific motivation'),
        ('Lack of methods', 'Lack of methods'),
        ('Avoidance of efforts', 'Avoidance of efforts'),
        ('Insufficient Quality Assurance', 'Insufficient Quality Assurance'),
    ]

    rdlc = forms.ChoiceField(choices=RDLC_CHOICES, required=False)
    harmful_effects = forms.ChoiceField(choices=HARMFUL_EFFECTS_CHOICES, required=False)
    possible_causes = forms.ChoiceField(choices=POSSIBLE_CAUSES_CHOICES, required=False)
