#!/bin/bash

# Get the directory of the script
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# Create virtual environment if not already exists
if [ ! -d "$DIR/CRAMPenv" ]; then
    python3 -m venv "$DIR/CRAMPenv"
fi

# Activate virtual environment
source "$DIR/CRAMPenv/bin/activate"

# Install Django if not already installed
if ! pip show django > /dev/null 2>&1; then
    pip install django
fi

# Navigate to the project directory
cd "$DIR/projectquestgame"

# Create start.sh only if it doesn't already exist
if [ ! -f "$DIR/start.sh" ]; then
    echo "#!/bin/bash" > "$DIR/start.sh"
    echo "# Check if virtual environment is activated" >> "$DIR/start.sh"
    echo "if [ -z \"\$VIRTUAL_ENV\" ]; then" >> "$DIR/start.sh"
    echo "    source \"$DIR/CRAMPenv/bin/activate\"" >> "$DIR/start.sh"
    echo "fi" >> "$DIR/start.sh"
    echo "cd \"$DIR/projectquestgame\"" >> "$DIR/start.sh"
    echo "python manage.py runserver &" >> "$DIR/start.sh"
    echo "xdg-open http://127.0.0.1:8000" >> "$DIR/start.sh"
    chmod +x "$DIR/start.sh"
    echo "start.sh created. Run start.sh to start the server and open the browser window."
else
    echo "start.sh already exists. You can run start.sh to start the server and open the browser window."
fi

# Start the Django development server and open the browser window
echo "Starting Django development server and opening the browser window..."
python manage.py runserver &
xdg-open http://127.0.0.1:8000

