from django.db import models

class Wave1Question(models.Model):
    wave_id = models.CharField(max_length=255)
    wave1questions = models.TextField()
    wave1questionspresent = models.TextField()
    user_answer = models.BooleanField(null=True)  # A field to store user answers (True for 'yes', False for 'no')
    tense = models.BooleanField(null=True)


class Wave2Question(models.Model):
    wave_id = models.CharField(max_length=255)
    wave2_question = models.TextField()
    wave2_question_present = models.TextField()
    user_answer = models.BooleanField(null=True)
    tense = models.BooleanField(null=True)

class EventDetails(models.Model):
    wave_id = models.CharField(max_length=255)
    wave2_1_no_details = models.TextField()
    wave2_1_yes_details = models.TextField()
    wave2_2_no_details = models.TextField()
    wave2_2_yes_details = models.TextField()
    wave2_3_no_details = models.TextField()
    wave2_3_yes_details = models.TextField()
    wave2_4_no_details = models.TextField()
    wave2_4_yes_details = models.TextField()

    wave2_1_yes_consequence = models.IntegerField(blank=True, null=True)
    wave2_1_no_consequence = models.IntegerField(blank=True, null=True)
    wave2_2_yes_consequence = models.IntegerField(blank=True, null=True)
    wave2_2_no_consequence = models.IntegerField(blank=True, null=True)
    wave2_3_yes_consequence = models.IntegerField(blank=True, null=True)
    wave2_3_no_consequence = models.IntegerField(blank=True, null=True)
    wave2_4_yes_consequence = models.IntegerField(blank=True, null=True)
    wave2_4_no_consequence = models.IntegerField(blank=True, null=True)


    def __str__(self):
        return f'EventDetails for {self.wave_id}'

class ExplorationData(models.Model):
    harmful_effects = models.CharField(max_length=255)
    possible_causes = models.CharField(max_length=255)
    possible_scenario = models.CharField(max_length=255)
    problem_reports = models.CharField(max_length=255)
    topic = models.CharField(max_length=255)
    rdlc = models.CharField(max_length=255)
