from django.urls import path
from . import views
from .views import update_user_answer, handle_event_details_consequences, reset_user_answers_part_2_only


urlpatterns = [
    path('', views.select_game_mode, name='select_game_mode'),
    path('select-category/', views.select_category, name='select_category'),
    path('select-category/<str:category>/', views.wave1_quiz, name='wave1_quiz'),
    path('quiz-completed/<str:category>/', views.quiz_completed, name='quiz_completed'),
    path('wave2-quiz/', views.wave2_quiz, name='wave2_quiz'),
    path('about/', views.about, name='about'),  # Updated URL
    path('wave2-quiz/bringiton/', views.wave2_bringiton, name='bringiton'),  # Updated URL
    path('wave2-quiz/data/', views.wave2_bringiton_data, name='wave2_bringiton_data'),
    path('reset-session-and-user-answers/', views.reset_session_and_user_answers, name='reset_session_and_user_answers'),
    path('reset-user-answers/', views.reset_user_answers, name='reset_user_answers'),
	path('reset_user_answers_part_2_only/', reset_user_answers_part_2_only, name='reset_user_answers_part_2_only'),
    path('quiz-completion/', views.quiz_completion, name='quiz_completion'),
    path('update_user_answer/', update_user_answer, name='update_user_answer'),
    path('handle_event_details_consequences/', handle_event_details_consequences, name='handle_event_details_consequences'),
    path('exploration/', views.exploration, name='exploration'),
	path('propose_topic/', views.propose_topic, name='propose_topic'),
	path('explorationsearch/', views.exploration_search, name='exploration_search'),
    path('exploration/<int:id>/', views.exploration_detail, name='exploration_detail'),
    path('exploration/<str:category>/', views.exploration_category, name='exploration_category'),
    path('reset-progress/', views.reset_progress, name='reset_progress'),
]
